"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qRegistryUrls = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const apply_from_1 = require("./apply-from");
const assignments_1 = require("./assignments");
const common_1 = require("./common");
const handlers_1 = require("./handlers");
const plugins_1 = require("./plugins");
const cleanupTmpContentSpec = (ctx) => {
    ctx.tmpRegistryContent = [];
    return ctx;
};
const qContentDescriptorSpec = (methodName, matcher) => {
    return good_enough_parser_1.query
        .sym(methodName, common_1.storeVarToken)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'methodName'))
        .alt(
    // includeGroup "foo.bar"
    matcher, 
    // includeGroup("foo.bar")
    good_enough_parser_1.query.tree({
        type: 'wrapped-tree',
        maxDepth: 1,
        startsWith: '(',
        endsWith: ')',
        search: good_enough_parser_1.query.begin().join(matcher).end(),
    }));
};
// includeModule('foo')
// excludeModuleByRegex('bar')
const qContentDescriptor = (mode) => {
    return good_enough_parser_1.query
        .alt(qContentDescriptorSpec((0, regex_1.regEx)(`^(?:${mode}Group|${mode}GroupByRegex|${mode}GroupAndSubgroups)$`), common_1.qGroupId), qContentDescriptorSpec((0, regex_1.regEx)(`^(?:${mode}Module|${mode}ModuleByRegex)$`), good_enough_parser_1.query.join(common_1.qGroupId, good_enough_parser_1.query.op(','), common_1.qArtifactId)), qContentDescriptorSpec((0, regex_1.regEx)(`^(?:${mode}Version|${mode}VersionByRegex)$`), good_enough_parser_1.query.join(common_1.qGroupId, good_enough_parser_1.query.op(','), common_1.qArtifactId, good_enough_parser_1.query.op(','), common_1.qVersion)))
        .handler(handlers_1.handleRegistryContent);
};
// content { includeModule('foo'); excludeModule('bar') }
const qRegistryContent = good_enough_parser_1.query.sym('content').tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '{',
    endsWith: '}',
    search: good_enough_parser_1.query.alt(qContentDescriptor('include'), qContentDescriptor('exclude')),
});
// uri("https://foo.bar/baz")
// "https://foo.bar/baz"
const qUri = good_enough_parser_1.query
    .alt(good_enough_parser_1.query.sym('uri').tree({
    maxDepth: 1,
    search: common_1.qValueMatcher,
}), common_1.qValueMatcher)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'registryUrl'));
// mavenCentral()
// mavenCentral { ... }
const qPredefinedRegistries = good_enough_parser_1.query
    .sym((0, regex_1.regEx)(`^(?:${Object.keys(common_1.REGISTRY_URLS).join('|')})$`), (ctx, node) => {
    const nodeTransformed = {
        ...node,
        type: 'string-value',
        value: common_1.REGISTRY_URLS[node.value],
    };
    (0, common_1.storeVarToken)(ctx, nodeTransformed);
    return ctx;
})
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'registryUrl'))
    .alt(good_enough_parser_1.query
    .tree({
    type: 'wrapped-tree',
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().end(),
})
    .opt(good_enough_parser_1.query.op('.').join(qRegistryContent)), good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    startsWith: '{',
    endsWith: '}',
    search: good_enough_parser_1.query.opt(qRegistryContent),
}));
// { url = "https://some.repo"; content { ... } }
const qMavenArtifactRegistry = good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '{',
    endsWith: '}',
    search: good_enough_parser_1.query.alt(good_enough_parser_1.query
        .sym('name')
        .opt(good_enough_parser_1.query.op('='))
        .join(common_1.qValueMatcher)
        .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'name')), good_enough_parser_1.query.sym('url').opt(good_enough_parser_1.query.op('=')).join(qUri), good_enough_parser_1.query.sym('setUrl').tree({
        maxDepth: 1,
        startsWith: '(',
        endsWith: ')',
        search: good_enough_parser_1.query.begin().join(qUri).end(),
    }), qRegistryContent),
});
// maven(url = uri("https://foo.bar/baz"))
// maven("https://foo.bar/baz") { content { ... } }
// maven { name = some; url = "https://foo.bar/${name}" }
const qCustomRegistryUrl = good_enough_parser_1.query.sym('maven').alt(good_enough_parser_1.query
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().opt(good_enough_parser_1.query.sym('url').op('=')).join(qUri).end(),
})
    .opt(qMavenArtifactRegistry), qMavenArtifactRegistry);
// forRepository { maven { ... } }
const qForRepository = good_enough_parser_1.query.sym('forRepository').tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    maxMatches: 1,
    startsWith: '{',
    endsWith: '}',
    search: good_enough_parser_1.query.alt(qPredefinedRegistries, qCustomRegistryUrl),
});
// filter { includeGroup(...); includeModule(...) }
const qFilter = good_enough_parser_1.query.sym('filter').tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '{',
    endsWith: '}',
    search: qContentDescriptor('include'),
});
// exclusiveContent { forRepository { ... }; filter { ... } }
const qExclusiveContent = good_enough_parser_1.query
    .sym('exclusiveContent', common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'registryType'))
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    maxMatches: 1,
    startsWith: '{',
    endsWith: '}',
    search: good_enough_parser_1.query.alt(good_enough_parser_1.query.join(qForRepository, qFilter), good_enough_parser_1.query.join(qFilter, qForRepository)),
});
const qRegistries = good_enough_parser_1.query
    .alt(qExclusiveContent, qPredefinedRegistries, qCustomRegistryUrl)
    .handler(handlers_1.handleRegistryUrl)
    .handler(cleanupTmpContentSpec)
    .handler(common_1.cleanupTempVars);
const qPluginManagement = good_enough_parser_1.query.sym('pluginManagement', common_1.storeVarToken).tree({
    type: 'wrapped-tree',
    startsWith: '{',
    endsWith: '}',
    preHandler: (ctx) => {
        ctx.tmpTokenStore.registryScope = ctx.varTokens;
        ctx.varTokens = [];
        return ctx;
    },
    search: good_enough_parser_1.query
        .handler((ctx) => {
        if (ctx.tmpTokenStore.registryScope) {
            ctx.tokenMap.registryScope = ctx.tmpTokenStore.registryScope;
        }
        return ctx;
    })
        .alt(assignments_1.qAssignments, apply_from_1.qApplyFrom, plugins_1.qPlugins, qRegistries),
    postHandler: (ctx) => {
        delete ctx.tmpTokenStore.registryScope;
        return ctx;
    },
});
exports.qRegistryUrls = good_enough_parser_1.query.alt(good_enough_parser_1.query.sym('publishing').tree(), qPluginManagement, qRegistries);
//# sourceMappingURL=registry-urls.js.map