"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qPlugins = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const common_1 = require("./common");
const handlers_1 = require("./handlers");
exports.qPlugins = good_enough_parser_1.query
    .sym((0, regex_1.regEx)(/^(?:id|kotlin)$/), common_1.storeVarToken)
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'methodName'))
    .alt(
// id "foo.bar" version "1.2.3"
common_1.qStringValue
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'pluginName'))
    .sym('version')
    .join(common_1.qVersion), 
// kotlin("jvm") version "1.3.71"
good_enough_parser_1.query
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(common_1.qStringValue).end(),
})
    .handler((ctx) => (0, common_1.storeInTokenMap)(ctx, 'pluginName'))
    .alt(
// id("foo.bar") version "1.2.3"
good_enough_parser_1.query.sym('version').join(common_1.qVersion), 
// id("foo.bar").version("1.2.3")
// id("foo.bar") version("1.2.3")
good_enough_parser_1.query
    .opt(good_enough_parser_1.query.op('.'))
    .sym('version')
    .tree({
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(common_1.qVersion).end(),
})))
    .handler(handlers_1.handlePlugin)
    .handler(common_1.cleanupTempVars);
//# sourceMappingURL=plugins.js.map