"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qToolchainVersion = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const common_1 = require("./common");
// (21)
const qVersionNumber = good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    maxMatches: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.num((ctx, node) => {
        ctx.javaLanguageVersion = node.value;
        return ctx;
    }),
});
// kotlin { jvmToolchain(17) }
// kotlin.jvmToolchain(17)
const qKotlinShortNotationToolchain = (0, common_1.qDotOrBraceExpr)('kotlin', good_enough_parser_1.query.sym('jvmToolchain').join(qVersionNumber));
// JavaLanguageVersion.of(21)
const qJavaLanguageVersion = good_enough_parser_1.query
    .sym('JavaLanguageVersion')
    .op('.')
    .sym('of')
    .join(qVersionNumber);
// java { toolchain { languageVersion = JavaLanguageVersion.of(21) } }
// kotlin { jvmToolchain { languageVersion.set(JavaLanguageVersion.of(17)) } }
const qLongFormToolchainVersion = (0, common_1.qDotOrBraceExpr)((0, regex_1.regEx)(/^(?:java|kotlin)$/), (0, common_1.qDotOrBraceExpr)((0, regex_1.regEx)(/^(?:toolchain|jvmToolchain)$/), good_enough_parser_1.query.sym('languageVersion').alt(good_enough_parser_1.query.op('=').join(qJavaLanguageVersion), good_enough_parser_1.query
    .op('.')
    .sym('set')
    .tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '(',
    endsWith: ')',
    search: good_enough_parser_1.query.begin().join(qJavaLanguageVersion).end(),
}))));
exports.qToolchainVersion = good_enough_parser_1.query.alt(qKotlinShortNotationToolchain, qLongFormToolchainVersion);
//# sourceMappingURL=language-version.js.map