import type { lexer, parser } from 'good-enough-parser';
import { query as q } from 'good-enough-parser';
import type { Ctx, NonEmptyArray, PackageVariables, VariableData } from '../types';
export declare const REGISTRY_URLS: {
    google: string;
    gradlePluginPortal: string;
    jcenter: string;
    mavenCentral: string;
};
export declare const GRADLE_PLUGINS: {
    checkstyle: string[];
    codenarc: string[];
    composeOptions: string[];
    detekt: string[];
    findbugs: string[];
    googleJavaFormat: string[];
    jacoco: string[];
    jmh: string[];
    lombok: string[];
    micronaut: string[];
    pmd: string[];
    spotbugs: string[];
};
export declare const GRADLE_TEST_SUITES: {
    useJunit: string;
    useJUnitJupiter: string;
    useKotlinTest: string;
    useSpock: string;
    useTestNG: string;
};
export declare function storeVarToken(ctx: Ctx, node: lexer.Token): Ctx;
export declare function increaseNestingDepth(ctx: Ctx): Ctx;
export declare function reduceNestingDepth(ctx: Ctx): Ctx;
export declare function prependNestingDepth(ctx: Ctx): Ctx;
export declare function storeInTokenMap(ctx: Ctx, tokenMapKey: string): Ctx;
export declare function loadFromTokenMap(ctx: Ctx, tokenMapKey: string): NonEmptyArray<lexer.Token>;
export declare function cleanupTempVars(ctx: Ctx): Ctx;
export declare function stripReservedPrefixFromKeyTokens(ctx: Ctx): Ctx;
export declare function coalesceVariable(ctx: Ctx): Ctx;
export declare function findVariableInKotlinImport(name: string, ctx: Ctx, variables: PackageVariables): VariableData | undefined;
export declare function findVariable(name: string, ctx: Ctx, variables?: PackageVariables): VariableData | undefined;
export declare function interpolateString(childTokens: lexer.Token[], ctx: Ctx, variables?: PackageVariables): string | null;
export declare const qStringValue: import("good-enough-parser/dist/cjs/query/builder").StrBuilder<Ctx>;
export declare const qStringValueAsSymbol: import("good-enough-parser/dist/cjs/query/builder").StrBuilder<Ctx>;
export declare const qVariableAssignmentIdentifier: import("good-enough-parser/dist/cjs/query/builder").SeqBuilder<Ctx, parser.Node>;
export declare const qVariableAccessIdentifier: import("good-enough-parser/dist/cjs/query/builder").SeqBuilder<Ctx, parser.Node>;
export declare const qPropertyAccessIdentifier: import("good-enough-parser/dist/cjs/query/builder").SeqBuilder<Ctx, parser.Node>;
export declare const qTemplateString: import("good-enough-parser/dist/cjs/query/builder").SeqBuilder<Ctx, parser.Tree>;
export declare const qConcatExpr: (...matchers: q.QueryBuilder<Ctx, parser.Node>[]) => q.QueryBuilder<Ctx, parser.Node>;
export declare const qValueMatcher: q.QueryBuilder<Ctx, parser.Node>;
export declare const qKotlinImport: import("good-enough-parser/dist/cjs/query/builder").SeqBuilder<Ctx, parser.Node>;
export declare const qDotOrBraceExpr: (symValue: q.SymMatcherValue, matcher: q.QueryBuilder<Ctx, parser.Node>) => q.QueryBuilder<Ctx, parser.Node>;
export declare const qGroupId: q.QueryBuilder<Ctx, parser.Node>;
export declare const qArtifactId: q.QueryBuilder<Ctx, parser.Node>;
export declare const qVersion: q.QueryBuilder<Ctx, parser.Node>;
