import type { PackageDependency } from '../../types';
import type { GradleManagerData } from '../types';
export declare const VERSIONS_PROPS = "versions.props";
export declare const VERSIONS_LOCK = "versions.lock";
export declare const LOCKFIlE_HEADER_TEXT: RegExp;
/**
 * Determines if Palantir gradle-consistent-versions is in use, https://github.com/palantir/gradle-consistent-versions.
 * Both `versions.props` and `versions.lock` must exist and the special header line of lock file must match
 *
 * @param versionsPropsFilename is the full file name path of `versions.props`
 * @param fileContents map with file contents of all files
 */
export declare function usesGcv(versionsPropsFilename: string, fileContents: Record<string, string | null>): boolean;
/**
 * Confirms whether the provided file name is the props file
 */
export declare function isGcvPropsFile(fileName: string): boolean;
/**
 * Confirms whether the provided file name is the lock file
 */
export declare function isGcvLockFile(fileName: string): boolean;
/**
 * Parses Gradle-Consistent-Versions files to figure out what dependencies, versions
 * and groups they contain. The parsing goes like this:
 * - Parse `versions.props` into deps (or groups) and versions, remembering file offsets
 * - Parse `versions.lock` into deps and lock-versions
 * - For each exact dep in props file, lookup the lock-version from lock file
 * - For each group/regex dep in props file, lookup the set of exact deps and versions in lock file
 *
 * @param propsFileName name and path of the props file
 * @param fileContents text content of all files
 */
export declare function parseGcv(propsFileName: string, fileContents: Record<string, string | null>): PackageDependency<GradleManagerData>[];
interface VersionWithPosition {
    version: string;
    filePos: number;
}
interface VersionWithDepType {
    version: string;
    depType: string;
}
/**
 * Parses `versions.lock`
 */
export declare function parseLockFile(input: string): Map<string, VersionWithDepType>;
/**
 * Parses `versions.props`, this is CR/LF safe
 * @param input the entire property file from file system
 * @return two maps, first being exact matches, second regex matches
 */
export declare function parsePropsFile(input: string): [Map<string, VersionWithPosition>, Map<string, VersionWithPosition>];
export {};
