import { z } from 'zod';
export declare const GleamToml: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    name: z.ZodString;
    dependencies: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    "dev-dependencies": z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    name: string;
    dependencies?: Record<string, string> | undefined;
    "dev-dependencies"?: Record<string, string> | undefined;
}, {
    name: string;
    dependencies?: Record<string, string> | undefined;
    "dev-dependencies"?: Record<string, string> | undefined;
}>>;
export declare const ManifestToml: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    packages: z.ZodOptional<z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        version: z.ZodString;
        requirements: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        requirements?: string[] | undefined;
    }, {
        name: string;
        version: string;
        requirements?: string[] | undefined;
    }>, "many">>;
}, "strip", z.ZodTypeAny, {
    packages?: {
        name: string;
        version: string;
        requirements?: string[] | undefined;
    }[] | undefined;
}, {
    packages?: {
        name: string;
        version: string;
        requirements?: string[] | undefined;
    }[] | undefined;
}>>;
export type GleamToml = z.infer<typeof GleamToml>;
export type ManifestToml = z.infer<typeof ManifestToml>;
