"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractLockFileVersions = extractLockFileVersions;
exports.parseLockFile = parseLockFile;
const logger_1 = require("../../../logger");
const array_1 = require("../../../util/array");
const fs_1 = require("../../../util/fs");
const schema_1 = require("./schema");
async function extractLockFileVersions(lockFilePath) {
    const content = await (0, fs_1.readLocalFile)(lockFilePath, 'utf8');
    if (!content) {
        logger_1.logger.debug(`Gleam lock file ${lockFilePath} not found`);
        return null;
    }
    const versionsByPackage = new Map();
    const lock = parseLockFile(content);
    if (!lock) {
        logger_1.logger.debug(`Error parsing Gleam lock file ${lockFilePath}`);
        return null;
    }
    for (const pkg of (0, array_1.coerceArray)(lock.packages)) {
        const versions = (0, array_1.coerceArray)(versionsByPackage.get(pkg.name));
        versions.push(pkg.version);
        versionsByPackage.set(pkg.name, versions);
    }
    return versionsByPackage;
}
function parseLockFile(lockFileContent) {
    const res = schema_1.ManifestToml.safeParse(lockFileContent);
    if (res.success) {
        return res.data;
    }
    logger_1.logger.debug({ err: res.error }, 'Error parsing manifest.toml.');
    return null;
}
//# sourceMappingURL=locked-version.js.map