import { z } from 'zod';
export declare const Package: z.ZodObject<{
    apiVersion: z.ZodString;
    kind: z.ZodUnion<[z.ZodLiteral<"Package">, z.ZodLiteral<"ClusterPackage">]>;
    spec: z.ZodObject<{
        packageInfo: z.ZodObject<{
            name: z.ZodString;
            version: z.ZodString;
            repositoryName: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        }, {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    }, {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    }>;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
    kind: "Package" | "ClusterPackage";
    spec: {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    };
}, {
    apiVersion: string;
    kind: "Package" | "ClusterPackage";
    spec: {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    };
}>;
export declare const PackageRepository: z.ZodObject<{
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"PackageRepository">;
    metadata: z.ZodObject<{
        name: z.ZodString;
        annotations: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        annotations?: Record<string, string> | undefined;
    }, {
        name: string;
        annotations?: Record<string, string> | undefined;
    }>;
    spec: z.ZodObject<{
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
    }, {
        url: string;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        annotations?: Record<string, string> | undefined;
    };
    apiVersion: string;
    kind: "PackageRepository";
    spec: {
        url: string;
    };
}, {
    metadata: {
        name: string;
        annotations?: Record<string, string> | undefined;
    };
    apiVersion: string;
    kind: "PackageRepository";
    spec: {
        url: string;
    };
}>;
export declare const GlasskubeResource: z.ZodUnion<[z.ZodObject<{
    apiVersion: z.ZodString;
    kind: z.ZodUnion<[z.ZodLiteral<"Package">, z.ZodLiteral<"ClusterPackage">]>;
    spec: z.ZodObject<{
        packageInfo: z.ZodObject<{
            name: z.ZodString;
            version: z.ZodString;
            repositoryName: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        }, {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    }, {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    }>;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
    kind: "Package" | "ClusterPackage";
    spec: {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    };
}, {
    apiVersion: string;
    kind: "Package" | "ClusterPackage";
    spec: {
        packageInfo: {
            name: string;
            version: string;
            repositoryName?: string | undefined;
        };
    };
}>, z.ZodObject<{
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"PackageRepository">;
    metadata: z.ZodObject<{
        name: z.ZodString;
        annotations: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        annotations?: Record<string, string> | undefined;
    }, {
        name: string;
        annotations?: Record<string, string> | undefined;
    }>;
    spec: z.ZodObject<{
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
    }, {
        url: string;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        annotations?: Record<string, string> | undefined;
    };
    apiVersion: string;
    kind: "PackageRepository";
    spec: {
        url: string;
    };
}, {
    metadata: {
        name: string;
        annotations?: Record<string, string> | undefined;
    };
    apiVersion: string;
    kind: "PackageRepository";
    spec: {
        url: string;
    };
}>]>;
export type Package = z.infer<typeof Package>;
export type PackageRepository = z.infer<typeof PackageRepository>;
export type GlasskubeResource = z.infer<typeof GlasskubeResource>;
