"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGitlabDep = getGitlabDep;
const regex_1 = require("../../../util/regex");
const extract_1 = require("../dockerfile/extract");
const depProxyRe = (0, regex_1.regEx)(`(?<prefix>\\$\\{?CI_DEPENDENCY_PROXY_(?:DIRECT_)?GROUP_IMAGE_PREFIX\\}?/)(?<depName>.+)`);
/**
 * Get image dependencies respecting Gitlab Dependency Proxy
 * @param imageName as used in .gitlab-ci.yml file
 * @return package dependency for the image
 */
function getGitlabDep(imageName, registryAliases) {
    const match = depProxyRe.exec(imageName);
    if (match?.groups) {
        const dep = { ...(0, extract_1.getDep)(match.groups.depName), replaceString: imageName };
        // TODO: types (#22198)
        dep.autoReplaceStringTemplate = `${match.groups.prefix}${dep.autoReplaceStringTemplate}`;
        return dep;
    }
    return (0, extract_1.getDep)(imageName, true, registryAliases);
}
//# sourceMappingURL=utils.js.map