"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabDocument = exports.Jobs = exports.Job = exports.MultiDocumentLocalIncludes = void 0;
const zod_1 = require("zod");
const array_1 = require("../../../util/array");
const schema_utils_1 = require("../../../util/schema-utils");
const url_1 = require("../../../util/url");
const LocalInclude = zod_1.z
    .union([
    zod_1.z.string(),
    zod_1.z.object({ local: zod_1.z.string() }).transform(({ local }) => local),
])
    .transform(url_1.trimLeadingSlash);
const DocumentLocalIncludes = zod_1.z
    .object({
    include: zod_1.z.union([
        (0, schema_utils_1.LooseArray)(LocalInclude),
        LocalInclude.transform(array_1.toArray),
    ]),
})
    .transform(({ include }) => include);
exports.MultiDocumentLocalIncludes = (0, schema_utils_1.LooseArray)(DocumentLocalIncludes).transform((includes) => includes.flat());
exports.Job = zod_1.z.object({
    image: zod_1.z
        .union([
        zod_1.z.string().transform((image) => ({
            type: 'image',
            value: image,
        })),
        zod_1.z.object({ name: zod_1.z.string() }).transform(({ name }) => ({
            type: 'image-name',
            value: name,
        })),
    ])
        .optional()
        .catch(undefined),
    services: (0, schema_utils_1.LooseArray)(zod_1.z.union([
        zod_1.z.string(),
        zod_1.z.object({ name: zod_1.z.string() }).transform(({ name }) => name),
    ])).catch([]),
});
exports.Jobs = (0, schema_utils_1.LooseRecord)(zod_1.z.string(), exports.Job)
    .catch({})
    .transform((x) => Object.values(x));
const GitlabInclude = zod_1.z
    .object({ component: zod_1.z.string() })
    .transform(({ component }) => component);
const GitlabIncludes = zod_1.z
    .union([(0, schema_utils_1.LooseArray)(GitlabInclude), GitlabInclude.transform(array_1.toArray)])
    .catch([]);
exports.GitlabDocument = zod_1.z
    .record(zod_1.z.unknown())
    .transform((obj) => {
    const { include, ...rest } = obj;
    const children = Object.values(rest);
    return { include, children };
})
    .transform(({ include, children }) => [
    ...GitlabDocumentArray.parse(children),
    ...GitlabIncludes.parse(include),
]);
const GitlabDocumentArray = (0, schema_utils_1.LooseArray)(exports.GitlabDocument).transform((x) => x.flat());
//# sourceMappingURL=schema.js.map