"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowSchema = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const StepsSchema = zod_1.z.object({
    uses: zod_1.z.string(),
    with: (0, schema_utils_1.LooseRecord)(zod_1.z.string()),
});
const WorkFlowJobsSchema = zod_1.z.object({
    jobs: (0, schema_utils_1.LooseRecord)(zod_1.z.object({
        container: zod_1.z
            .union([
            zod_1.z.string(),
            zod_1.z.object({ image: zod_1.z.string() }).transform((v) => v.image),
        ])
            .optional()
            .catch(undefined),
        services: (0, schema_utils_1.LooseRecord)(zod_1.z.union([
            zod_1.z.object({ image: zod_1.z.string() }).transform((v) => v.image),
            zod_1.z.string(),
        ]))
            .catch({})
            .transform((services) => Object.values(services)),
        'runs-on': zod_1.z
            .union([zod_1.z.string().transform((v) => [v]), zod_1.z.array(zod_1.z.string())])
            .catch([]),
        steps: (0, schema_utils_1.LooseArray)(StepsSchema).catch([]),
    })),
});
const ActionsSchema = zod_1.z.object({
    runs: zod_1.z.object({
        using: zod_1.z.string(),
        steps: (0, schema_utils_1.LooseArray)(StepsSchema).optional().catch([]),
    }),
});
exports.WorkflowSchema = schema_utils_1.Yaml.pipe(zod_1.z.union([WorkFlowJobsSchema, ActionsSchema, zod_1.z.null()])).catch((0, schema_utils_1.withDebugMessage)(null, 'Does not match schema'));
//# sourceMappingURL=schema.js.map