"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const gitea_tags_1 = require("../../datasource/gitea-tags");
const github_runners_1 = require("../../datasource/github-runners");
const github_tags_1 = require("../../datasource/github-tags");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'GitHub Actions';
exports.url = 'https://docs.github.com/en/actions';
exports.categories = ['ci'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/(^|/)(workflow-templates|\\.(?:github|gitea|forgejo)/(?:workflows|actions))/.+\\.ya?ml$/',
        '/(^|/)action\\.ya?ml$/',
    ],
};
exports.supportedDatasources = [
    gitea_tags_1.GiteaTagsDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    github_runners_1.GithubRunnersDatasource.id,
];
//# sourceMappingURL=index.js.map