"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = updateDependency;
const tslib_1 = require("tslib");
const simple_git_1 = tslib_1.__importDefault(require("simple-git"));
const upath_1 = tslib_1.__importDefault(require("upath"));
const global_1 = require("../../../config/global");
const logger_1 = require("../../../logger");
const utils_1 = require("../../../util/exec/utils");
const fs_1 = require("../../../util/fs");
const auth_1 = require("../../../util/git/auth");
async function updateDependency({ fileContent, upgrade, }) {
    const localDir = global_1.GlobalConfig.get('localDir');
    const gitSubmoduleAuthEnvironmentVariables = (0, auth_1.getGitEnvironmentVariables)([
        'git-tags',
        'git-refs',
    ]);
    const gitEnv = (0, utils_1.getChildEnv)({ env: gitSubmoduleAuthEnvironmentVariables });
    const git = (0, simple_git_1.default)(localDir).env(gitEnv);
    const submoduleGit = (0, simple_git_1.default)(upath_1.default.join(localDir, upgrade.depName)).env(gitEnv);
    try {
        await git.submoduleUpdate(['--checkout', '--init', upgrade.depName]);
        await submoduleGit.checkout([upgrade.newDigest]);
        if (upgrade.newValue && upgrade.currentValue !== upgrade.newValue) {
            await git.subModule([
                'set-branch',
                '--branch',
                upgrade.newValue,
                upgrade.depName,
            ]);
            const updatedPackageContent = await (0, fs_1.readLocalFile)(upgrade.packageFile, 'utf8');
            return updatedPackageContent;
        }
        return fileContent;
    }
    catch (err) {
        logger_1.logger.debug({ err }, 'submodule checkout error');
        return null;
    }
}
//# sourceMappingURL=update.js.map