import { z } from 'zod';
export declare const KubernetesResource: z.ZodObject<{
    apiVersion: z.ZodString;
    kind: z.ZodString;
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: string;
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: string;
}>;
export declare const HelmRelease: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"HelmRelease">;
    spec: z.ZodObject<{
        chart: z.ZodOptional<z.ZodObject<{
            spec: z.ZodObject<{
                chart: z.ZodString;
                version: z.ZodOptional<z.ZodString>;
                sourceRef: z.ZodOptional<z.ZodObject<{
                    kind: z.ZodOptional<z.ZodString>;
                    name: z.ZodOptional<z.ZodString>;
                    namespace: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                }, {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                }>>;
            }, "strip", z.ZodTypeAny, {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            }, {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        }, {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        }>>;
        chartRef: z.ZodOptional<z.ZodObject<{
            kind: z.ZodOptional<z.ZodString>;
            name: z.ZodOptional<z.ZodString>;
            namespace: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        }, {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        }>>;
        values: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    }, {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRelease";
    spec: {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRelease";
    spec: {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    };
}>;
export type HelmRelease = z.infer<typeof HelmRelease>;
export declare const HelmRepository: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"HelmRepository">;
    spec: z.ZodObject<{
        url: z.ZodString;
        type: z.ZodOptional<z.ZodEnum<["oci", "default"]>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        type?: "default" | "oci" | undefined;
    }, {
        url: string;
        type?: "default" | "oci" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRepository";
    spec: {
        url: string;
        type?: "default" | "oci" | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRepository";
    spec: {
        url: string;
        type?: "default" | "oci" | undefined;
    };
}>;
export type HelmRepository = z.infer<typeof HelmRepository>;
export declare const HelmChart: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"HelmChart">;
    spec: z.ZodObject<{
        chart: z.ZodString;
        version: z.ZodOptional<z.ZodString>;
        sourceRef: z.ZodObject<{
            kind: z.ZodOptional<z.ZodString>;
            name: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name?: string | undefined;
            kind?: string | undefined;
        }, {
            name?: string | undefined;
            kind?: string | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    }, {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmChart";
    spec: {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmChart";
    spec: {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    };
}>;
export type HelmChart = z.infer<typeof HelmChart>;
export declare const GitRepository: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"GitRepository">;
    spec: z.ZodObject<{
        url: z.ZodString;
        ref: z.ZodOptional<z.ZodObject<{
            tag: z.ZodOptional<z.ZodString>;
            commit: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            commit?: string | undefined;
            tag?: string | undefined;
        }, {
            commit?: string | undefined;
            tag?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }, {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "GitRepository";
    spec: {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "GitRepository";
    spec: {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}>;
export declare const OCIRepository: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"OCIRepository">;
    spec: z.ZodObject<{
        url: z.ZodString;
        ref: z.ZodOptional<z.ZodObject<{
            tag: z.ZodOptional<z.ZodString>;
            digest: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            digest?: string | undefined;
            tag?: string | undefined;
        }, {
            digest?: string | undefined;
            tag?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }, {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "OCIRepository";
    spec: {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "OCIRepository";
    spec: {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}>;
export declare const Kustomization: z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"Kustomization">;
    spec: z.ZodObject<{
        images: z.ZodOptional<z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            newName: z.ZodOptional<z.ZodString>;
            newTag: z.ZodOptional<z.ZodString>;
            digest: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }, {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    }, {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Kustomization";
    spec: {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Kustomization";
    spec: {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    };
}>;
export declare const FluxResource: z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"HelmRelease">;
    spec: z.ZodObject<{
        chart: z.ZodOptional<z.ZodObject<{
            spec: z.ZodObject<{
                chart: z.ZodString;
                version: z.ZodOptional<z.ZodString>;
                sourceRef: z.ZodOptional<z.ZodObject<{
                    kind: z.ZodOptional<z.ZodString>;
                    name: z.ZodOptional<z.ZodString>;
                    namespace: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                }, {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                }>>;
            }, "strip", z.ZodTypeAny, {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            }, {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        }, {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        }>>;
        chartRef: z.ZodOptional<z.ZodObject<{
            kind: z.ZodOptional<z.ZodString>;
            name: z.ZodOptional<z.ZodString>;
            namespace: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        }, {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        }>>;
        values: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    }, {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRelease";
    spec: {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRelease";
    spec: {
        values?: Record<string, unknown> | undefined;
        chart?: {
            spec: {
                chart: string;
                version?: string | undefined;
                sourceRef?: {
                    namespace?: string | undefined;
                    name?: string | undefined;
                    kind?: string | undefined;
                } | undefined;
            };
        } | undefined;
        chartRef?: {
            namespace?: string | undefined;
            name?: string | undefined;
            kind?: string | undefined;
        } | undefined;
    };
}>, z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"HelmRepository">;
    spec: z.ZodObject<{
        url: z.ZodString;
        type: z.ZodOptional<z.ZodEnum<["oci", "default"]>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        type?: "default" | "oci" | undefined;
    }, {
        url: string;
        type?: "default" | "oci" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRepository";
    spec: {
        url: string;
        type?: "default" | "oci" | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmRepository";
    spec: {
        url: string;
        type?: "default" | "oci" | undefined;
    };
}>]>, z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"HelmChart">;
    spec: z.ZodObject<{
        chart: z.ZodString;
        version: z.ZodOptional<z.ZodString>;
        sourceRef: z.ZodObject<{
            kind: z.ZodOptional<z.ZodString>;
            name: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name?: string | undefined;
            kind?: string | undefined;
        }, {
            name?: string | undefined;
            kind?: string | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    }, {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmChart";
    spec: {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "HelmChart";
    spec: {
        chart: string;
        sourceRef: {
            name?: string | undefined;
            kind?: string | undefined;
        };
        version?: string | undefined;
    };
}>]>, z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"GitRepository">;
    spec: z.ZodObject<{
        url: z.ZodString;
        ref: z.ZodOptional<z.ZodObject<{
            tag: z.ZodOptional<z.ZodString>;
            commit: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            commit?: string | undefined;
            tag?: string | undefined;
        }, {
            commit?: string | undefined;
            tag?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }, {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "GitRepository";
    spec: {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "GitRepository";
    spec: {
        url: string;
        ref?: {
            commit?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}>]>, z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"OCIRepository">;
    spec: z.ZodObject<{
        url: z.ZodString;
        ref: z.ZodOptional<z.ZodObject<{
            tag: z.ZodOptional<z.ZodString>;
            digest: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            digest?: string | undefined;
            tag?: string | undefined;
        }, {
            digest?: string | undefined;
            tag?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }, {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "OCIRepository";
    spec: {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "OCIRepository";
    spec: {
        url: string;
        ref?: {
            digest?: string | undefined;
            tag?: string | undefined;
        } | undefined;
    };
}>]>, z.ZodObject<{
    metadata: z.ZodObject<{
        name: z.ZodString;
        namespace: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        namespace?: string | undefined;
    }, {
        name: string;
        namespace?: string | undefined;
    }>;
} & {
    apiVersion: z.ZodString;
    kind: z.ZodLiteral<"Kustomization">;
    spec: z.ZodObject<{
        images: z.ZodOptional<z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            newName: z.ZodOptional<z.ZodString>;
            newTag: z.ZodOptional<z.ZodString>;
            digest: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }, {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    }, {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Kustomization";
    spec: {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    };
}, {
    metadata: {
        name: string;
        namespace?: string | undefined;
    };
    apiVersion: string;
    kind: "Kustomization";
    spec: {
        images?: {
            name: string;
            digest?: string | undefined;
            newTag?: string | undefined;
            newName?: string | undefined;
        }[] | undefined;
    };
}>]>;
export type FluxResource = z.infer<typeof FluxResource>;
