"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.updateArtifacts = exports.extractPackageFile = exports.extractAllPackageFiles = void 0;
const bitbucket_tags_1 = require("../../datasource/bitbucket-tags");
const docker_1 = require("../../datasource/docker");
const git_refs_1 = require("../../datasource/git-refs");
const git_tags_1 = require("../../datasource/git-tags");
const github_releases_1 = require("../../datasource/github-releases");
const github_tags_1 = require("../../datasource/github-tags");
const gitlab_tags_1 = require("../../datasource/gitlab-tags");
const helm_1 = require("../../datasource/helm");
const common_1 = require("./common");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
exports.url = 'https://fluxcd.io/flux';
exports.categories = ['cd', 'kubernetes'];
exports.defaultConfig = {
    managerFilePatterns: [`/${common_1.systemManifestFileNameRegex}/`],
};
exports.supportedDatasources = [
    github_releases_1.GithubReleasesDatasource.id,
    git_refs_1.GitRefsDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    gitlab_tags_1.GitlabTagsDatasource.id,
    git_tags_1.GitTagsDatasource.id,
    bitbucket_tags_1.BitbucketTagsDatasource.id,
    helm_1.HelmDatasource.id,
    docker_1.DockerDatasource.id,
];
//# sourceMappingURL=index.js.map