"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const docker_1 = require("../../datasource/docker");
const git_tags_1 = require("../../datasource/git-tags");
const helm_1 = require("../../datasource/helm");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'Rancher Fleet';
exports.url = 'https://fleet.rancher.io';
exports.categories = ['cd', 'kubernetes'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)fleet\\.ya?ml/'],
};
exports.supportedDatasources = [
    git_tags_1.GitTagsDatasource.id,
    helm_1.HelmDatasource.id,
    docker_1.DockerDatasource.id,
];
//# sourceMappingURL=index.js.map