import { z } from 'zod';
declare const DockerComposeService: z.ZodObject<{
    image: z.ZodOptional<z.ZodString>;
    build: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
        context: z.ZodOptional<z.ZodString>;
        dockerfile: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        dockerfile?: string | undefined;
        context?: string | undefined;
    }, {
        dockerfile?: string | undefined;
        context?: string | undefined;
    }>]>>;
}, "strip", z.ZodTypeAny, {
    build?: string | {
        dockerfile?: string | undefined;
        context?: string | undefined;
    } | undefined;
    image?: string | undefined;
}, {
    build?: string | {
        dockerfile?: string | undefined;
        context?: string | undefined;
    } | undefined;
    image?: string | undefined;
}>;
export declare const DockerComposeFile: z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    /**
     *  compose does not use this strictly, so we shouldn't be either
     *  https://docs.docker.com/compose/compose-file/04-version-and-name/#version-top-level-element
     */
    version: z.ZodOptional<z.ZodString>;
    services: z.ZodRecord<z.ZodString, z.ZodObject<{
        image: z.ZodOptional<z.ZodString>;
        build: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
            context: z.ZodOptional<z.ZodString>;
            dockerfile: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }>]>>;
    }, "strip", z.ZodTypeAny, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }>>;
}, "strip", z.ZodUnknown, z.objectOutputType<{
    /**
     *  compose does not use this strictly, so we shouldn't be either
     *  https://docs.docker.com/compose/compose-file/04-version-and-name/#version-top-level-element
     */
    version: z.ZodOptional<z.ZodString>;
    services: z.ZodRecord<z.ZodString, z.ZodObject<{
        image: z.ZodOptional<z.ZodString>;
        build: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
            context: z.ZodOptional<z.ZodString>;
            dockerfile: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }>]>>;
    }, "strip", z.ZodTypeAny, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }>>;
}, z.ZodUnknown, "strip">, z.objectInputType<{
    /**
     *  compose does not use this strictly, so we shouldn't be either
     *  https://docs.docker.com/compose/compose-file/04-version-and-name/#version-top-level-element
     */
    version: z.ZodOptional<z.ZodString>;
    services: z.ZodRecord<z.ZodString, z.ZodObject<{
        image: z.ZodOptional<z.ZodString>;
        build: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
            context: z.ZodOptional<z.ZodString>;
            dockerfile: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }>]>>;
    }, "strip", z.ZodTypeAny, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }>>;
}, z.ZodUnknown, "strip">>, {
    version?: string;
    services: Record<string, z.infer<typeof DockerComposeService>>;
    extensions?: Record<string, {
        image: string;
    }>;
}, z.objectInputType<{
    /**
     *  compose does not use this strictly, so we shouldn't be either
     *  https://docs.docker.com/compose/compose-file/04-version-and-name/#version-top-level-element
     */
    version: z.ZodOptional<z.ZodString>;
    services: z.ZodRecord<z.ZodString, z.ZodObject<{
        image: z.ZodOptional<z.ZodString>;
        build: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
            context: z.ZodOptional<z.ZodString>;
            dockerfile: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }, {
            dockerfile?: string | undefined;
            context?: string | undefined;
        }>]>>;
    }, "strip", z.ZodTypeAny, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }, {
        build?: string | {
            dockerfile?: string | undefined;
            context?: string | undefined;
        } | undefined;
        image?: string | undefined;
    }>>;
}, z.ZodUnknown, "strip">>, z.ZodRecord<z.ZodString, z.ZodObject<{
    image: z.ZodOptional<z.ZodString>;
    build: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
        context: z.ZodOptional<z.ZodString>;
        dockerfile: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        dockerfile?: string | undefined;
        context?: string | undefined;
    }, {
        dockerfile?: string | undefined;
        context?: string | undefined;
    }>]>>;
}, "strip", z.ZodTypeAny, {
    build?: string | {
        dockerfile?: string | undefined;
        context?: string | undefined;
    } | undefined;
    image?: string | undefined;
}, {
    build?: string | {
        dockerfile?: string | undefined;
        context?: string | undefined;
    } | undefined;
    image?: string | undefined;
}>>]>;
export type DockerComposeFile = z.infer<typeof DockerComposeFile>;
export {};
