"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.name = exports.extractPackageFile = void 0;
const docker_1 = require("../../datasource/docker");
const golang_version_1 = require("../../datasource/golang-version");
const node_version_1 = require("../../datasource/node-version");
const python_version_1 = require("../../datasource/python-version");
const ruby_version_1 = require("../../datasource/ruby-version");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.name = 'Dev Container';
exports.url = 'https://code.visualstudio.com/docs/devcontainers/containers';
exports.categories = ['docker'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/^.devcontainer/devcontainer.json$/',
        '/^.devcontainer.json$/',
    ],
};
exports.supportedDatasources = [
    docker_1.DockerDatasource.id,
    golang_version_1.GolangVersionDatasource.id,
    node_version_1.NodeVersionDatasource.id,
    python_version_1.PythonVersionDatasource.id,
    ruby_version_1.RubyVersionDatasource.id,
];
//# sourceMappingURL=index.js.map