"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.displayName = exports.supportedDatasources = exports.defaultConfig = exports.categories = void 0;
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../../logger");
const common_1 = require("../../../../util/common");
const toml_1 = require("../../../../util/toml");
const yaml_1 = require("../../../../util/yaml");
const utils_1 = require("../utils");
const utils_2 = require("./utils");
exports.categories = ['custom'];
exports.defaultConfig = {
    pinDigests: false,
};
exports.supportedDatasources = ['*'];
exports.displayName = 'JSONata';
async function extractPackageFile(content, packageFile, config) {
    let json;
    try {
        switch (config.fileFormat) {
            case 'json':
                json = (0, common_1.parseJson)(content, packageFile);
                break;
            case 'yaml':
                json = (0, yaml_1.parseYaml)(content);
                break;
            case 'toml':
                json = (0, toml_1.parse)(content);
                break;
        }
    }
    catch (err) {
        logger_1.logger.debug({ err, fileName: packageFile, fileFormat: config.fileFormat }, 'Error while parsing file');
        return null;
    }
    if (is_1.default.nullOrUndefined(json)) {
        return null;
    }
    const deps = await (0, utils_2.handleMatching)(json, packageFile, config);
    if (!deps.length) {
        return null;
    }
    const res = {
        deps,
        matchStrings: config.matchStrings,
        fileFormat: config.fileFormat,
    };
    // copy over templates for autoreplace
    for (const field of utils_1.validMatchFields.map((f) => `${f}Template`)) {
        if (config[field]) {
            res[field] = config[field];
        }
    }
    return res;
}
//# sourceMappingURL=index.js.map