"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const parser_1 = require("./parser");
function extractPackageFile(content, _packageFile) {
    const result = (0, parser_1.parse)(content);
    if (!result?.deps.length) {
        return null;
    }
    const { deps, perlVersion } = result;
    const extractedConstraints = perlVersion ? { perl: perlVersion } : undefined;
    return { deps, ...(extractedConstraints && { extractedConstraints }) };
}
//# sourceMappingURL=extract.js.map