"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPythonVersionConstraint = getPythonVersionConstraint;
exports.getCopierVersionConstraint = getCopierVersionConstraint;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
function getPythonVersionConstraint(config) {
    const { constraints = {} } = config;
    const { python } = constraints;
    if (is_1.default.nonEmptyString(python)) {
        logger_1.logger.debug('Using python constraint from config');
        return python;
    }
    return undefined;
}
function getCopierVersionConstraint(config) {
    const { constraints = {} } = config;
    const { copier } = constraints;
    if (is_1.default.nonEmptyString(copier)) {
        logger_1.logger.debug('Using copier constraint from config');
        return copier;
    }
    return '';
}
//# sourceMappingURL=utils.js.map