"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDependency = updateDependency;
const logger_1 = require("../../../logger");
const updateLine = '#copier updated';
/**
 * updateDependency appends a comment line once.
 * This is only for the purpose of triggering the artifact update.
 * Copier needs to update its answers file itself.
 */
function updateDependency({ fileContent, upgrade, }) {
    logger_1.logger.trace({ upgrade }, `copier.updateDependency()`);
    if (!fileContent.endsWith(updateLine)) {
        logger_1.logger.debug(`append update line to the fileContent if it hasn't been`);
        return `${fileContent}\n${updateLine}`;
    }
    return fileContent;
}
//# sourceMappingURL=update.js.map