"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.composerVersioningId = void 0;
exports.getComposerArguments = getComposerArguments;
exports.getComposerUpdateArguments = getComposerUpdateArguments;
exports.getPhpConstraint = getPhpConstraint;
exports.requireComposerDependencyInstallation = requireComposerDependencyInstallation;
exports.extractConstraints = extractConstraints;
exports.isArtifactAuthEnabled = isArtifactAuthEnabled;
const tslib_1 = require("tslib");
// TODO: types (#22198)
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const shlex_1 = require("shlex");
const global_1 = require("../../../config/global");
const logger_1 = require("../../../logger");
const number_1 = require("../../../util/number");
const composer_1 = require("../../versioning/composer");
Object.defineProperty(exports, "composerVersioningId", { enumerable: true, get: function () { return composer_1.id; } });
const depRequireInstall = new Set(['symfony/flex']);
function getComposerArguments(config, toolConstraint) {
    let args = '';
    if (config.composerIgnorePlatformReqs) {
        if (config.composerIgnorePlatformReqs.length === 0) {
            if (is_1.default.string(toolConstraint.constraint) &&
                composer_1.api.intersects(toolConstraint.constraint, '^2.2')) {
                args += " --ignore-platform-req='ext-*' --ignore-platform-req='lib-*'";
            }
            else {
                args += ' --ignore-platform-reqs';
            }
        }
        else {
            config.composerIgnorePlatformReqs.forEach((req) => {
                args += ' --ignore-platform-req ' + (0, shlex_1.quote)(req);
            });
        }
    }
    args += ' --no-ansi --no-interaction';
    if (!global_1.GlobalConfig.get('allowScripts') || config.ignoreScripts) {
        args += ' --no-scripts --no-autoloader';
    }
    if (!global_1.GlobalConfig.get('allowPlugins') || config.ignorePlugins) {
        args += ' --no-plugins';
    }
    return args;
}
function getComposerUpdateArguments(config, toolConstraint) {
    let args = getComposerArguments(config, toolConstraint);
    if (is_1.default.string(toolConstraint.constraint) &&
        composer_1.api.intersects(toolConstraint.constraint, '>=2.7')) {
        args += ' --minimal-changes';
    }
    return args;
}
function getPhpConstraint(constraints) {
    const { php } = constraints;
    if (php) {
        logger_1.logger.debug('Using php constraint from config');
        return php;
    }
    return null;
}
function requireComposerDependencyInstallation({ packages, packagesDev, }) {
    return (packages.some((p) => depRequireInstall.has(p.name)) === true ||
        packagesDev.some((p) => depRequireInstall.has(p.name)) === true);
}
function extractConstraints({ config, require, requireDev }, { pluginApiVersion }) {
    const res = { composer: '1.*' };
    // extract php
    const phpVersion = config?.platform.php;
    if (phpVersion) {
        const major = composer_1.api.getMajor(phpVersion);
        const minor = (0, number_1.coerceNumber)(composer_1.api.getMinor(phpVersion));
        const patch = (0, number_1.coerceNumber)(composer_1.api.getPatch(phpVersion));
        res.php = `<=${major}.${minor}.${patch}`;
    }
    else if (require.php) {
        res.php = require.php;
    }
    // extract direct composer dependency
    if (require['composer/composer']) {
        res.composer = require['composer/composer'];
    }
    else if (requireDev['composer/composer']) {
        res.composer = requireDev['composer/composer'];
    }
    // composer platform package
    else if (require.composer) {
        res.composer = require.composer;
    }
    else if (requireDev.composer) {
        res.composer = requireDev.composer;
    }
    // check last used composer version
    else if (pluginApiVersion) {
        const major = composer_1.api.getMajor(pluginApiVersion);
        const minor = composer_1.api.getMinor(pluginApiVersion);
        res.composer = `^${major}.${minor}`;
    }
    // check composer api dependency
    else if (require['composer-runtime-api']) {
        const major = composer_1.api.getMajor(require['composer-runtime-api']);
        const minor = composer_1.api.getMinor(require['composer-runtime-api']);
        res.composer = `^${major}.${minor}`;
    }
    return res;
}
function isArtifactAuthEnabled(rule) {
    return !rule.artifactAuth || rule.artifactAuth.includes('composer');
}
//# sourceMappingURL=utils.js.map