"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateLockedDependency = updateLockedDependency;
const logger_1 = require("../../../logger");
const schema_utils_1 = require("../../../util/schema-utils");
const composer_1 = require("../../versioning/composer");
const schema_1 = require("./schema");
function updateLockedDependency(config) {
    const { depName, currentVersion, newVersion, lockFile, lockFileContent } = config;
    logger_1.logger.debug(`composer.updateLockedDependency: ${depName}@${currentVersion} -> ${newVersion} [${lockFile}]`);
    try {
        const lockfile = schema_utils_1.Json.pipe(schema_1.Lockfile).parse(lockFileContent);
        if (lockfile?.packages.find(({ name, version }) => name === depName && composer_1.api.equals(version, newVersion))) {
            return { status: 'already-updated' };
        }
        return { status: 'unsupported' };
    }
    catch (err) /* istanbul ignore next */ {
        logger_1.logger.debug({ err }, 'composer.updateLockedDependency() error');
        return { status: 'update-failed' };
    }
}
//# sourceMappingURL=update-locked.js.map