"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = exports.getRangeStrategy = void 0;
const docker_1 = require("../../datasource/docker");
const orb_1 = require("../../datasource/orb");
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var range_1 = require("./range");
Object.defineProperty(exports, "getRangeStrategy", { enumerable: true, get: function () { return range_1.getRangeStrategy; } });
exports.displayName = 'CircleCI';
exports.url = 'https://circleci.com/docs/configuration-reference';
exports.categories = ['ci'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)\\.circleci/.+\\.ya?ml$/'],
};
exports.supportedDatasources = [docker_1.DockerDatasource.id, orb_1.OrbDatasource.id];
//# sourceMappingURL=index.js.map