"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const result_1 = require("../../../util/result");
const yaml_1 = require("../../../util/yaml");
const orb_1 = require("../../datasource/orb");
const npmVersioning = tslib_1.__importStar(require("../../versioning/npm"));
const extract_1 = require("../dockerfile/extract");
const schema_1 = require("./schema");
function extractDefinition(deps, definition, registryAliases) {
    for (const [key, orb] of Object.entries(definition.orbs)) {
        if (typeof orb === 'string') {
            const [packageName, currentValue] = orb.split('@');
            deps.push({
                depName: key,
                packageName,
                depType: 'orb',
                currentValue,
                versioning: npmVersioning.id,
                datasource: orb_1.OrbDatasource.id,
            });
        }
        else {
            extractDefinition(deps, orb, registryAliases);
        }
    }
    // extract environments
    const environments = [...definition.executors, ...definition.jobs];
    for (const dockerImage of environments) {
        deps.push({
            ...(0, extract_1.getDep)(dockerImage, true, registryAliases),
            depType: 'docker',
        });
    }
}
function extractPackageFile(content, packageFile, config) {
    const { val: parsed, err } = result_1.Result.wrap(() => schema_1.CircleCiFile.parse((0, yaml_1.parseSingleYaml)(content))).unwrap();
    if (err) {
        logger_1.logger.debug({ err, packageFile }, 'Error extracting circleci images');
        return null;
    }
    const registryAliases = config?.registryAliases ?? {};
    const deps = [];
    extractDefinition(deps, parsed, registryAliases);
    for (const alias of parsed.aliases) {
        deps.push({
            ...(0, extract_1.getDep)(alias, true, registryAliases),
            depType: 'docker',
        });
    }
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map