"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bumpPackageVersion = bumpPackageVersion;
const tslib_1 = require("tslib");
const semver_1 = tslib_1.__importDefault(require("semver"));
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
function bumpPackageVersion(content, currentValue, bumpVersion) {
    logger_1.logger.debug({ bumpVersion, currentValue }, 'Checking if we should bump Cargo.toml version');
    let bumpedContent = content;
    if (!semver_1.default.valid(currentValue)) {
        logger_1.logger.warn({ currentValue }, 'Unable to bump Cargo.toml version, not a valid semver');
        return { bumpedContent };
    }
    try {
        const newCrateVersion = semver_1.default.inc(currentValue, bumpVersion);
        if (!newCrateVersion) {
            throw new Error('semver inc failed');
        }
        logger_1.logger.debug({ newCrateVersion });
        bumpedContent = content.replace((0, regex_1.regEx)(`^(?<version>version[ \\t]*=[ \\t]*['"])[^'"]*`, 'm'), `$<version>${newCrateVersion}`);
        if (bumpedContent === content) {
            logger_1.logger.debug('Version was already bumped');
        }
        else {
            logger_1.logger.debug('Bumped Cargo.toml version');
        }
    }
    catch {
        logger_1.logger.warn({
            content,
            currentValue,
            bumpVersion,
        }, 'Failed to bumpVersion');
    }
    return { bumpedContent };
}
//# sourceMappingURL=update.js.map