"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateLockedDependency = updateLockedDependency;
const logger_1 = require("../../../logger");
const locked_version_1 = require("./locked-version");
function updateLockedDependency(config) {
    const { depName, currentVersion, newVersion, lockFile, lockFileContent } = config;
    logger_1.logger.debug(`cargo.updateLockedDependency: ${depName}@${currentVersion} -> ${newVersion} [${lockFile}]`);
    try {
        const locked = (0, locked_version_1.extractLockFileContentVersions)(lockFileContent);
        if (locked?.get(depName)?.find((version) => version === newVersion)) {
            return { status: 'already-updated' };
        }
        return { status: 'unsupported' };
    }
    catch (err) {
        logger_1.logger.debug({ err }, 'cargo.updateLockedDependency() error');
        return { status: 'update-failed' };
    }
}
//# sourceMappingURL=update-locked.js.map