"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileMatchesWorkspaces = fileMatchesWorkspaces;
exports.filesMatchingWorkspaces = filesMatchingWorkspaces;
const tslib_1 = require("tslib");
const upath_1 = tslib_1.__importDefault(require("upath"));
const minimatch_js_1 = require("../../../util/minimatch.js");
function fileMatchesWorkspaces(pwd, fileName, workspaces) {
    if (!fileName.startsWith(pwd)) {
        return false;
    }
    const relativeFile = upath_1.default
        .relative(pwd, fileName)
        .replace(/\/package\.json$/, '');
    return workspaces.some((pattern) => 
    // minimatch will also return true for an exact match
    (0, minimatch_js_1.minimatch)(pattern, { dot: true }).match(relativeFile));
}
function filesMatchingWorkspaces(pwd, files, workspaces) {
    return files.filter((file) => fileMatchesWorkspaces(pwd, file, workspaces));
}
//# sourceMappingURL=utils.js.map