"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.supportsLockFileMaintenance = exports.supersedesManagers = exports.categories = exports.url = exports.updateDependency = exports.getRangeStrategy = exports.extractAllPackageFiles = exports.updateArtifacts = void 0;
const github_tags_1 = require("../../datasource/github-tags");
const npm_1 = require("../../datasource/npm");
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
var npm_2 = require("../npm");
Object.defineProperty(exports, "getRangeStrategy", { enumerable: true, get: function () { return npm_2.getRangeStrategy; } });
Object.defineProperty(exports, "updateDependency", { enumerable: true, get: function () { return npm_2.updateDependency; } });
exports.url = 'https://bun.sh/docs/cli/install';
exports.categories = ['js'];
exports.supersedesManagers = ['npm'];
exports.supportsLockFileMaintenance = true;
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)bun\\.lockb?$/', '/(^|/)package\\.json$/'],
    digest: {
        prBodyDefinitions: {
            Change: '{{#if displayFrom}}`{{{displayFrom}}}` -> {{else}}{{#if currentValue}}`{{{currentValue}}}` -> {{/if}}{{/if}}{{#if displayTo}}`{{{displayTo}}}`{{else}}`{{{newValue}}}`{{/if}}',
        },
    },
    prBodyDefinitions: {
        Change: "[{{#if displayFrom}}`{{{displayFrom}}}` -> {{else}}{{#if currentValue}}`{{{currentValue}}}` -> {{/if}}{{/if}}{{#if displayTo}}`{{{displayTo}}}`{{else}}`{{{newValue}}}`{{/if}}]({{#if depName}}https://renovatebot.com/diffs/npm/{{replace '/' '%2f' depName}}/{{{currentVersion}}}/{{{newVersion}}}{{/if}})",
    },
};
exports.supportedDatasources = [github_tags_1.GithubTagsDatasource.id, npm_1.NpmDatasource.id];
//# sourceMappingURL=index.js.map