"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = void 0;
exports.extractPackageFile = extractPackageFile;
const npm_1 = require("../../datasource/npm");
const npm_2 = require("../../versioning/npm");
exports.categories = ['js'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)\\.bun-version$/'],
    versioning: npm_2.id,
};
exports.supportedDatasources = [npm_1.NpmDatasource.id];
function extractPackageFile(content) {
    if (!content) {
        return null;
    }
    if (content.split('\n').length > 2) {
        return null;
    }
    const dep = {
        depName: 'Bun',
        packageName: 'bun',
        currentValue: content.trim(),
        datasource: npm_1.NpmDatasource.id,
    };
    if (!(0, npm_2.isValid)(content.trim())) {
        dep.skipReason = 'invalid-version';
    }
    return { deps: [dep] };
}
//# sourceMappingURL=index.js.map