"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectDescriptorToml = exports.ProjectDescriptor = void 0;
exports.isBuildpackByName = isBuildpackByName;
exports.isBuildpackByURI = isBuildpackByURI;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const BuildpackByName = zod_1.z.object({
    id: zod_1.z.string(),
    version: zod_1.z.string().optional(),
});
const BuildpackByURI = zod_1.z.object({
    uri: zod_1.z.string(),
});
const BuildpackGroup = BuildpackByName.or(BuildpackByURI);
function isBuildpackByName(group) {
    return 'id' in group;
}
function isBuildpackByURI(group) {
    return 'uri' in group;
}
const IoBuildpacks = zod_1.z.object({
    builder: zod_1.z.string().optional(),
    group: zod_1.z.array(BuildpackGroup).optional(),
});
exports.ProjectDescriptor = zod_1.z.object({
    _: zod_1.z.object({
        'schema-version': zod_1.z.string(),
    }),
    io: zod_1.z
        .object({
        buildpacks: IoBuildpacks.optional(),
    })
        .optional(),
});
exports.ProjectDescriptorToml = schema_utils_1.Toml.pipe(exports.ProjectDescriptor);
//# sourceMappingURL=schema.js.map