import { z } from 'zod';
declare const BuildpackByName: z.ZodObject<{
    id: z.ZodString;
    version: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    id: string;
    version?: string | undefined;
}, {
    id: string;
    version?: string | undefined;
}>;
declare const BuildpackByURI: z.ZodObject<{
    uri: z.ZodString;
}, "strip", z.ZodTypeAny, {
    uri: string;
}, {
    uri: string;
}>;
declare const BuildpackGroup: z.ZodUnion<[z.ZodObject<{
    id: z.ZodString;
    version: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    id: string;
    version?: string | undefined;
}, {
    id: string;
    version?: string | undefined;
}>, z.ZodObject<{
    uri: z.ZodString;
}, "strip", z.ZodTypeAny, {
    uri: string;
}, {
    uri: string;
}>]>;
type BuildpackByName = z.infer<typeof BuildpackByName>;
type BuildpackByURI = z.infer<typeof BuildpackByURI>;
type BuildpackGroup = z.infer<typeof BuildpackGroup>;
export declare function isBuildpackByName(group: BuildpackGroup): group is BuildpackByName;
export declare function isBuildpackByURI(group: BuildpackGroup): group is BuildpackByURI;
export declare const ProjectDescriptor: z.ZodObject<{
    _: z.ZodObject<{
        'schema-version': z.ZodString;
    }, "strip", z.ZodTypeAny, {
        'schema-version': string;
    }, {
        'schema-version': string;
    }>;
    io: z.ZodOptional<z.ZodObject<{
        buildpacks: z.ZodOptional<z.ZodObject<{
            builder: z.ZodOptional<z.ZodString>;
            group: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodObject<{
                id: z.ZodString;
                version: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                id: string;
                version?: string | undefined;
            }, {
                id: string;
                version?: string | undefined;
            }>, z.ZodObject<{
                uri: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                uri: string;
            }, {
                uri: string;
            }>]>, "many">>;
        }, "strip", z.ZodTypeAny, {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        }, {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    }, {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    _: {
        'schema-version': string;
    };
    io?: {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    } | undefined;
}, {
    _: {
        'schema-version': string;
    };
    io?: {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    } | undefined;
}>;
export type ProjectDescriptor = z.infer<typeof ProjectDescriptor>;
export declare const ProjectDescriptorToml: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    _: z.ZodObject<{
        'schema-version': z.ZodString;
    }, "strip", z.ZodTypeAny, {
        'schema-version': string;
    }, {
        'schema-version': string;
    }>;
    io: z.ZodOptional<z.ZodObject<{
        buildpacks: z.ZodOptional<z.ZodObject<{
            builder: z.ZodOptional<z.ZodString>;
            group: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodObject<{
                id: z.ZodString;
                version: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                id: string;
                version?: string | undefined;
            }, {
                id: string;
                version?: string | undefined;
            }>, z.ZodObject<{
                uri: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                uri: string;
            }, {
                uri: string;
            }>]>, "many">>;
        }, "strip", z.ZodTypeAny, {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        }, {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    }, {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    _: {
        'schema-version': string;
    };
    io?: {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    } | undefined;
}, {
    _: {
        'schema-version': string;
    };
    io?: {
        buildpacks?: {
            group?: ({
                id: string;
                version?: string | undefined;
            } | {
                uri: string;
            })[] | undefined;
            builder?: string | undefined;
        } | undefined;
    } | undefined;
}>>;
export {};
