"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.categories = exports.defaultConfig = exports.extractPackageFile = void 0;
const buildpacks_registry_1 = require("../../datasource/buildpacks-registry");
const docker_1 = require("../../datasource/docker");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.defaultConfig = {
    commitMessageTopic: 'buildpack {{depName}}',
    managerFilePatterns: ['/(^|/)project\\.toml$/'],
    pinDigests: false,
};
exports.categories = ['docker', 'ci', 'cd'];
exports.supportedDatasources = [
    docker_1.DockerDatasource.id,
    buildpacks_registry_1.BuildpacksRegistryDatasource.id,
];
//# sourceMappingURL=index.js.map