"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OciTarget = exports.ociRules = void 0;
const zod_1 = require("zod");
const docker_1 = require("../../../datasource/docker");
const docker_2 = require("../../../versioning/docker");
exports.ociRules = ['oci_pull', '_oci_pull'];
exports.OciTarget = zod_1.z
    .object({
    rule: zod_1.z.enum(exports.ociRules),
    name: zod_1.z.string(),
    image: zod_1.z.string(),
    tag: zod_1.z.string().optional(),
    digest: zod_1.z.string().optional(),
})
    .transform(({ rule, name, image, tag, digest }) => [
    {
        datasource: docker_1.DockerDatasource.id,
        versioning: docker_2.id,
        depType: rule,
        depName: name,
        packageName: image,
        currentValue: tag,
        currentDigest: digest,
    },
]);
//# sourceMappingURL=oci.js.map