import { z } from 'zod';
import type { PackageDependency } from '../../types';
export declare const ociRules: readonly ["oci_pull", "_oci_pull"];
export declare const OciTarget: z.ZodEffects<z.ZodObject<{
    rule: z.ZodEnum<["oci_pull", "_oci_pull"]>;
    name: z.ZodString;
    image: z.ZodString;
    tag: z.ZodOptional<z.ZodString>;
    digest: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    image: string;
    rule: "oci_pull" | "_oci_pull";
    digest?: string | undefined;
    tag?: string | undefined;
}, {
    name: string;
    image: string;
    rule: "oci_pull" | "_oci_pull";
    digest?: string | undefined;
    tag?: string | undefined;
}>, PackageDependency<Record<string, any>>[], {
    name: string;
    image: string;
    rule: "oci_pull" | "_oci_pull";
    digest?: string | undefined;
    tag?: string | undefined;
}>;
