import { z } from 'zod';
import type { PackageDependency } from '../../types';
export declare function parseGithubPath(pathname: string): Partial<PackageDependency> | null;
export declare function parseArchiveUrl(urlString: string | undefined | null): Partial<PackageDependency> | null;
export declare const httpRules: readonly ["http_archive", "_http_archive", "http_file", "_http_file"];
export declare const HttpTarget: z.ZodEffects<z.ZodEffects<z.ZodObject<{
    rule: z.ZodEnum<["http_archive", "_http_archive", "http_file", "_http_file"]>;
    name: z.ZodString;
    url: z.ZodOptional<z.ZodString>;
    urls: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    sha256: z.ZodString;
}, "strip", z.ZodTypeAny, {
    name: string;
    sha256: string;
    rule: "http_archive" | "_http_archive" | "http_file" | "_http_file";
    url?: string | undefined;
    urls?: string[] | undefined;
}, {
    name: string;
    sha256: string;
    rule: "http_archive" | "_http_archive" | "http_file" | "_http_file";
    url?: string | undefined;
    urls?: string[] | undefined;
}>, {
    name: string;
    sha256: string;
    rule: "http_archive" | "_http_archive" | "http_file" | "_http_file";
    url?: string | undefined;
    urls?: string[] | undefined;
}, {
    name: string;
    sha256: string;
    rule: "http_archive" | "_http_archive" | "http_file" | "_http_file";
    url?: string | undefined;
    urls?: string[] | undefined;
}>, PackageDependency<Record<string, any>>[], {
    name: string;
    sha256: string;
    rule: "http_archive" | "_http_archive" | "http_file" | "_http_file";
    url?: string | undefined;
    urls?: string[] | undefined;
}>;
