import { z } from 'zod';
import type { PackageDependency } from '../../types';
export declare const gitRules: readonly ["git_repository", "_git_repository", "new_git_repository", "_new_git_repository"];
export declare const GitTarget: z.ZodEffects<z.ZodEffects<z.ZodObject<{
    rule: z.ZodEnum<["git_repository", "_git_repository", "new_git_repository", "_new_git_repository"]>;
    name: z.ZodString;
    tag: z.ZodOptional<z.ZodString>;
    commit: z.ZodOptional<z.ZodString>;
    remote: z.ZodString;
}, "strip", z.ZodTypeAny, {
    name: string;
    rule: "git_repository" | "_git_repository" | "new_git_repository" | "_new_git_repository";
    remote: string;
    commit?: string | undefined;
    tag?: string | undefined;
}, {
    name: string;
    rule: "git_repository" | "_git_repository" | "new_git_repository" | "_new_git_repository";
    remote: string;
    commit?: string | undefined;
    tag?: string | undefined;
}>, {
    name: string;
    rule: "git_repository" | "_git_repository" | "new_git_repository" | "_new_git_repository";
    remote: string;
    commit?: string | undefined;
    tag?: string | undefined;
}, {
    name: string;
    rule: "git_repository" | "_git_repository" | "new_git_repository" | "_new_git_repository";
    remote: string;
    commit?: string | undefined;
    tag?: string | undefined;
}>, PackageDependency<Record<string, any>>[], {
    name: string;
    rule: "git_repository" | "_git_repository" | "new_git_repository" | "_new_git_repository";
    remote: string;
    commit?: string | undefined;
    tag?: string | undefined;
}>;
