"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerTarget = exports.dockerRules = void 0;
const zod_1 = require("zod");
const docker_1 = require("../../../datasource/docker");
const docker_2 = require("../../../versioning/docker");
exports.dockerRules = ['container_pull', '_container_pull'];
exports.DockerTarget = zod_1.z
    .object({
    rule: zod_1.z.enum(exports.dockerRules),
    name: zod_1.z.string(),
    tag: zod_1.z.string(),
    digest: zod_1.z.string(),
    repository: zod_1.z.string(),
    registry: zod_1.z.string(),
})
    .transform(({ rule, name, repository, tag, digest, registry, }) => [
    {
        datasource: docker_1.DockerDatasource.id,
        versioning: docker_2.id,
        depType: rule,
        depName: name,
        packageName: repository,
        currentValue: tag,
        currentDigest: digest,
        registryUrls: [registry],
    },
]);
//# sourceMappingURL=docker.js.map