import { z } from 'zod';
import type { PackageDependency } from '../../types';
export declare const dockerRules: readonly ["container_pull", "_container_pull"];
export declare const DockerTarget: z.ZodEffects<z.ZodObject<{
    rule: z.ZodEnum<["container_pull", "_container_pull"]>;
    name: z.ZodString;
    tag: z.ZodString;
    digest: z.ZodString;
    repository: z.ZodString;
    registry: z.ZodString;
}, "strip", z.ZodTypeAny, {
    digest: string;
    name: string;
    tag: string;
    registry: string;
    repository: string;
    rule: "container_pull" | "_container_pull";
}, {
    digest: string;
    name: string;
    tag: string;
    registry: string;
    repository: string;
    rule: "container_pull" | "_container_pull";
}>, PackageDependency<Record<string, any>>[], {
    digest: string;
    name: string;
    tag: string;
    registry: string;
    repository: string;
    rule: "container_pull" | "_container_pull";
}>;
