"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.updateArtifacts = exports.extractPackageFile = void 0;
const docker_1 = require("../../datasource/docker");
const github_releases_1 = require("../../datasource/github-releases");
const github_tags_1 = require("../../datasource/github-tags");
const go_1 = require("../../datasource/go");
const artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = 'https://bazel.build/docs';
exports.categories = ['bazel'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/(^|/)WORKSPACE(|\\.bazel|\\.bzlmod)$/',
        '/\\.WORKSPACE\\.bazel$/',
        '/\\.bzl$/',
    ],
};
exports.supportedDatasources = [
    docker_1.DockerDatasource.id,
    github_releases_1.GithubReleasesDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    go_1.GoDatasource.id,
];
//# sourceMappingURL=index.js.map