"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const parser_1 = require("./parser");
const rules_1 = require("./rules");
const docker_1 = require("./rules/docker");
const git_1 = require("./rules/git");
const go_1 = require("./rules/go");
const oci_1 = require("./rules/oci");
function extractPackageFile(content, packageFile) {
    const deps = [];
    const fragments = (0, parser_1.parse)(content, packageFile);
    if (!fragments) {
        return null;
    }
    for (let idx = 0; idx < fragments.length; idx += 1) {
        const fragment = fragments[idx];
        for (const dep of (0, rules_1.extractDepsFromFragment)(fragment)) {
            dep.managerData = { idx };
            // Selectively provide `replaceString` in order to make auto-replace
            // functionality work correctly.
            const rules = [...docker_1.dockerRules, ...oci_1.ociRules, ...git_1.gitRules, ...go_1.goRules];
            const replaceString = fragment.value;
            if (rules.some((rule) => replaceString.startsWith(rule))) {
                if (dep.currentValue && dep.currentDigest) {
                    dep.replaceString = replaceString;
                }
            }
            deps.push(dep);
        }
    }
    return deps.length ? { deps } : null;
}
//# sourceMappingURL=extract.js.map