import { z } from 'zod';
import type { SkipReason } from '../../../types';
import type { PackageDependency } from '../types';
export interface BasePackageDep extends PackageDependency {
    depType: string;
    depName: string;
}
type BasePackageDepMergeKeys = Extract<keyof BasePackageDep, 'registryUrls'>;
export interface MergePackageDep extends BasePackageDep {
    bazelDepMergeFields: BasePackageDepMergeKeys[];
}
export interface OverridePackageDep extends BasePackageDep {
    bazelDepSkipReason: SkipReason;
}
export type BazelModulePackageDep = BasePackageDep | OverridePackageDep | MergePackageDep;
export declare function bazelModulePackageDepToPackageDependency(bmpd: BazelModulePackageDep): PackageDependency;
export declare const RuleToBazelModulePackageDep: z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"rule">;
    isComplete: z.ZodBoolean;
} & {
    rule: z.ZodLiteral<"bazel_dep">;
    children: z.ZodObject<{
        name: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        version: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>>;
    }, "strip", z.ZodTypeAny, {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }, {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    type: "rule";
    rule: "bazel_dep";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}, {
    type: "rule";
    rule: "bazel_dep";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}>, BasePackageDep, {
    type: "rule";
    rule: "bazel_dep";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}>, z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"rule">;
    isComplete: z.ZodBoolean;
} & {
    rule: z.ZodLiteral<"git_override">;
    children: z.ZodObject<{
        module_name: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        remote: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        commit: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
    }, "strip", z.ZodTypeAny, {
        commit: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    }, {
        commit: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    }>;
}, "strip", z.ZodTypeAny, {
    type: "rule";
    rule: "git_override";
    children: {
        commit: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    isComplete: boolean;
}, {
    type: "rule";
    rule: "git_override";
    children: {
        commit: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    isComplete: boolean;
}>, OverridePackageDep, {
    type: "rule";
    rule: "git_override";
    children: {
        commit: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    isComplete: boolean;
}>, z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"rule">;
    isComplete: z.ZodBoolean;
} & {
    rule: z.ZodLiteral<"single_version_override">;
    children: z.ZodObject<{
        module_name: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        version: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>>;
        registry: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>>;
    }, "strip", z.ZodTypeAny, {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        registry?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }, {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        registry?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    type: "rule";
    rule: "single_version_override";
    children: {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        registry?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}, {
    type: "rule";
    rule: "single_version_override";
    children: {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        registry?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}>, BasePackageDep, {
    type: "rule";
    rule: "single_version_override";
    children: {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        version?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        registry?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}>, z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"rule">;
    isComplete: z.ZodBoolean;
} & {
    rule: z.ZodEnum<["archive_override", "local_path_override"]>;
    children: z.ZodObject<{
        module_name: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
    }, "strip", z.ZodTypeAny, {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    }, {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    }>;
}, "strip", z.ZodTypeAny, {
    type: "rule";
    rule: "archive_override" | "local_path_override";
    children: {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    isComplete: boolean;
}, {
    type: "rule";
    rule: "archive_override" | "local_path_override";
    children: {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    isComplete: boolean;
}>, OverridePackageDep, {
    type: "rule";
    rule: "archive_override" | "local_path_override";
    children: {
        module_name: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    isComplete: boolean;
}>]>;
export declare function processModulePkgDeps(packageDeps: BazelModulePackageDep[]): PackageDependency[];
export declare function toPackageDependencies(packageDeps: BazelModulePackageDep[]): PackageDependency[];
export declare const GitRepositoryToPackageDep: z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"rule">;
    isComplete: z.ZodBoolean;
} & {
    rule: z.ZodUnion<[z.ZodLiteral<"git_repository">, z.ZodLiteral<"new_git_repository">]>;
    children: z.ZodObject<{
        name: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        remote: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        commit: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>>;
        tag: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>>;
    }, "strip", z.ZodTypeAny, {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        commit?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }, {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        commit?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    type: "rule";
    rule: "git_repository" | "new_git_repository";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        commit?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}, {
    type: "rule";
    rule: "git_repository" | "new_git_repository";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        commit?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}>, BasePackageDep, {
    type: "rule";
    rule: "git_repository" | "new_git_repository";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        remote: {
            type: "string";
            value: string;
            isComplete: true;
        };
        commit?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    isComplete: boolean;
}>;
export {};
