"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rules = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const common_1 = require("./common");
// For the purpose of parsing bazel module files in Renovate, we consider a rule
// to be any "direct function application". For example:
//
//     bazel_dep(name = "platforms", version = "0.0.11")
//     ^^^^^^^^^ --> the "rule"
//
// In bazel, rules have typically a more narrow definition. However:
// - They are syntactically indistinguishable from, say, macros.
// - In informal speech, "rule" is often used as umbrella term.
const supportedRules = [
    'archive_override',
    'bazel_dep',
    'git_override',
    'local_path_override',
    'single_version_override',
    'git_repository',
    'new_git_repository',
];
const supportedRulesRegex = (0, regex_1.regEx)(`^${supportedRules.join('|')}$`);
exports.rules = good_enough_parser_1.query
    .sym(supportedRulesRegex, (ctx, token) => ctx.startRule(token.value))
    .join(good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    search: common_1.kvParams,
    postHandler: (ctx) => ctx.endRule(),
}));
//# sourceMappingURL=rules.js.map