import { z } from 'zod';
import type { PackageDependency } from '../../types';
export declare const ociExtensionPrefix = "oci";
export declare const ociExtensionTags: string[];
export declare const RuleToDockerPackageDep: z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"extensionTag">;
    rawExtension: z.ZodString;
    isComplete: z.ZodBoolean;
    offset: z.ZodNumber;
    rawString: z.ZodOptional<z.ZodString>;
} & {
    extension: z.ZodLiteral<"oci">;
    tag: z.ZodLiteral<"pull">;
    children: z.ZodObject<{
        name: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        image: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        tag: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>>;
        digest: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>>;
    }, "strip", z.ZodTypeAny, {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        image: {
            type: "string";
            value: string;
            isComplete: true;
        };
        digest?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }, {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        image: {
            type: "string";
            value: string;
            isComplete: true;
        };
        digest?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    type: "extensionTag";
    tag: "pull";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        image: {
            type: "string";
            value: string;
            isComplete: true;
        };
        digest?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    offset: number;
    isComplete: boolean;
    extension: "oci";
    rawExtension: string;
    rawString?: string | undefined;
}, {
    type: "extensionTag";
    tag: "pull";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        image: {
            type: "string";
            value: string;
            isComplete: true;
        };
        digest?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    offset: number;
    isComplete: boolean;
    extension: "oci";
    rawExtension: string;
    rawString?: string | undefined;
}>, PackageDependency<Record<string, any>>, {
    type: "extensionTag";
    tag: "pull";
    children: {
        name: {
            type: "string";
            value: string;
            isComplete: true;
        };
        image: {
            type: "string";
            value: string;
            isComplete: true;
        };
        digest?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
        tag?: {
            type: "string";
            value: string;
            isComplete: true;
        } | undefined;
    };
    offset: number;
    isComplete: boolean;
    extension: "oci";
    rawExtension: string;
    rawString?: string | undefined;
}>;
