import { z } from 'zod';
import type { PackageDependency } from '../../types';
export declare const mavenExtensionPrefix = "maven";
export declare const mavenExtensionTags: string[];
export declare const RuleToMavenPackageDep: z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"extensionTag">;
    rawExtension: z.ZodString;
    isComplete: z.ZodBoolean;
    offset: z.ZodNumber;
    rawString: z.ZodOptional<z.ZodString>;
} & {
    extension: z.ZodLiteral<"maven">;
    tag: z.ZodLiteral<"artifact">;
    children: z.ZodObject<{
        artifact: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        group: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
        version: z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
            isComplete: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
            isComplete: true;
        }, {
            type: "string";
            value: string;
            isComplete: true;
        }>;
    }, "strip", z.ZodTypeAny, {
        version: {
            type: "string";
            value: string;
            isComplete: true;
        };
        artifact: {
            type: "string";
            value: string;
            isComplete: true;
        };
        group: {
            type: "string";
            value: string;
            isComplete: true;
        };
    }, {
        version: {
            type: "string";
            value: string;
            isComplete: true;
        };
        artifact: {
            type: "string";
            value: string;
            isComplete: true;
        };
        group: {
            type: "string";
            value: string;
            isComplete: true;
        };
    }>;
}, "strip", z.ZodTypeAny, {
    type: "extensionTag";
    tag: "artifact";
    children: {
        version: {
            type: "string";
            value: string;
            isComplete: true;
        };
        artifact: {
            type: "string";
            value: string;
            isComplete: true;
        };
        group: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    offset: number;
    isComplete: boolean;
    extension: "maven";
    rawExtension: string;
    rawString?: string | undefined;
}, {
    type: "extensionTag";
    tag: "artifact";
    children: {
        version: {
            type: "string";
            value: string;
            isComplete: true;
        };
        artifact: {
            type: "string";
            value: string;
            isComplete: true;
        };
        group: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    offset: number;
    isComplete: boolean;
    extension: "maven";
    rawExtension: string;
    rawString?: string | undefined;
}>, PackageDependency<Record<string, any>>[], {
    type: "extensionTag";
    tag: "artifact";
    children: {
        version: {
            type: "string";
            value: string;
            isComplete: true;
        };
        artifact: {
            type: "string";
            value: string;
            isComplete: true;
        };
        group: {
            type: "string";
            value: string;
            isComplete: true;
        };
    };
    offset: number;
    isComplete: boolean;
    extension: "maven";
    rawExtension: string;
    rawString?: string | undefined;
}>, z.ZodEffects<z.ZodObject<{
    type: z.ZodLiteral<"extensionTag">;
    rawExtension: z.ZodString;
    isComplete: z.ZodBoolean;
    offset: z.ZodNumber;
    rawString: z.ZodOptional<z.ZodString>;
} & {
    extension: z.ZodLiteral<"maven">;
    tag: z.ZodLiteral<"install">;
    children: z.ZodObject<{
        artifacts: z.ZodEffects<z.ZodObject<{
            type: z.ZodLiteral<"array">;
            items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                type: "string";
                value: string;
                isComplete: true;
            }[], any[]>;
            isComplete: z.ZodBoolean;
        }, "strip", z.ZodTypeAny, {
            type: "array";
            isComplete: boolean;
            items: {
                type: "string";
                value: string;
                isComplete: true;
            }[];
        }, {
            type: "array";
            isComplete: boolean;
            items: any[];
        }>, {
            version: string;
            artifact: string;
            group: string;
        }[], {
            type: "array";
            isComplete: boolean;
            items: any[];
        }>;
        repositories: z.ZodObject<{
            type: z.ZodLiteral<"array">;
            items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                type: "string";
                value: string;
                isComplete: true;
            }[], any[]>;
            isComplete: z.ZodBoolean;
        }, "strip", z.ZodTypeAny, {
            type: "array";
            isComplete: boolean;
            items: {
                type: "string";
                value: string;
                isComplete: true;
            }[];
        }, {
            type: "array";
            isComplete: boolean;
            items: any[];
        }>;
    }, "strip", z.ZodTypeAny, {
        repositories: {
            type: "array";
            isComplete: boolean;
            items: {
                type: "string";
                value: string;
                isComplete: true;
            }[];
        };
        artifacts: {
            version: string;
            artifact: string;
            group: string;
        }[];
    }, {
        repositories: {
            type: "array";
            isComplete: boolean;
            items: any[];
        };
        artifacts: {
            type: "array";
            isComplete: boolean;
            items: any[];
        };
    }>;
}, "strip", z.ZodTypeAny, {
    type: "extensionTag";
    tag: "install";
    children: {
        repositories: {
            type: "array";
            isComplete: boolean;
            items: {
                type: "string";
                value: string;
                isComplete: true;
            }[];
        };
        artifacts: {
            version: string;
            artifact: string;
            group: string;
        }[];
    };
    offset: number;
    isComplete: boolean;
    extension: "maven";
    rawExtension: string;
    rawString?: string | undefined;
}, {
    type: "extensionTag";
    tag: "install";
    children: {
        repositories: {
            type: "array";
            isComplete: boolean;
            items: any[];
        };
        artifacts: {
            type: "array";
            isComplete: boolean;
            items: any[];
        };
    };
    offset: number;
    isComplete: boolean;
    extension: "maven";
    rawExtension: string;
    rawString?: string | undefined;
}>, PackageDependency<Record<string, any>>[], {
    type: "extensionTag";
    tag: "install";
    children: {
        repositories: {
            type: "array";
            isComplete: boolean;
            items: any[];
        };
        artifacts: {
            type: "array";
            isComplete: boolean;
            items: any[];
        };
    };
    offset: number;
    isComplete: boolean;
    extension: "maven";
    rawExtension: string;
    rawString?: string | undefined;
}>]>;
export declare function fillRegistryUrls(packageDeps: PackageDependency[][]): PackageDependency[];
