"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = parse;
const good_enough_parser_1 = require("good-enough-parser");
const context_1 = require("./context");
const extension_tags_1 = require("./extension-tags");
const rules_1 = require("./rules");
const rule = good_enough_parser_1.query.alt(rules_1.rules, extension_tags_1.extensionTags);
const query = good_enough_parser_1.query.tree({
    type: 'root-tree',
    maxDepth: 16,
    search: rule,
});
const starlarkLang = good_enough_parser_1.lang.createLang('starlark');
function parse(input) {
    const parsedResult = starlarkLang.query(input, query, new context_1.Ctx(input));
    return parsedResult?.results ?? [];
}
//# sourceMappingURL=index.js.map