import { z } from 'zod';
export declare const StringFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"string">;
    value: z.ZodString;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    value: string;
    isComplete: true;
}, {
    type: "string";
    value: string;
    isComplete: true;
}>;
export declare const BooleanFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"boolean">;
    value: z.ZodBoolean;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}>;
declare const PrimitiveFragmentsSchema: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    type: z.ZodLiteral<"string">;
    value: z.ZodString;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    value: string;
    isComplete: true;
}, {
    type: "string";
    value: string;
    isComplete: true;
}>, z.ZodObject<{
    type: z.ZodLiteral<"boolean">;
    value: z.ZodBoolean;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}>]>;
export declare const ArrayFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"array">;
    items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    })[], any[]>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "array";
    isComplete: boolean;
    items: ({
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    })[];
}, {
    type: "array";
    isComplete: boolean;
    items: any[];
}>;
export declare const StringArrayFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"array">;
    items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        type: "string";
        value: string;
        isComplete: true;
    }[], any[]>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "array";
    isComplete: boolean;
    items: {
        type: "string";
        value: string;
        isComplete: true;
    }[];
}, {
    type: "array";
    isComplete: boolean;
    items: any[];
}>;
declare const ValueFragmentsSchema: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    type: z.ZodLiteral<"string">;
    value: z.ZodString;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    value: string;
    isComplete: true;
}, {
    type: "string";
    value: string;
    isComplete: true;
}>, z.ZodObject<{
    type: z.ZodLiteral<"boolean">;
    value: z.ZodBoolean;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}>, z.ZodObject<{
    type: z.ZodLiteral<"array">;
    items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    })[], any[]>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "array";
    isComplete: boolean;
    items: ({
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    })[];
}, {
    type: "array";
    isComplete: boolean;
    items: any[];
}>]>;
export declare const RuleFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"rule">;
    rule: z.ZodString;
    children: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>, Record<string, any>>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "rule";
    rule: string;
    children: Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>;
    isComplete: boolean;
}, {
    type: "rule";
    rule: string;
    children: Record<string, any>;
    isComplete: boolean;
}>;
export declare const PreparedExtensionTagFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"preparedExtensionTag">;
    extension: z.ZodString;
    rawExtension: z.ZodString;
    offset: z.ZodNumber;
    isComplete: z.ZodLiteral<false>;
}, "strip", z.ZodTypeAny, {
    type: "preparedExtensionTag";
    offset: number;
    isComplete: false;
    extension: string;
    rawExtension: string;
}, {
    type: "preparedExtensionTag";
    offset: number;
    isComplete: false;
    extension: string;
    rawExtension: string;
}>;
export declare const ExtensionTagFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"extensionTag">;
    extension: z.ZodString;
    rawExtension: z.ZodString;
    tag: z.ZodString;
    children: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>, Record<string, any>>;
    isComplete: z.ZodBoolean;
    offset: z.ZodNumber;
    rawString: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "extensionTag";
    tag: string;
    children: Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>;
    offset: number;
    isComplete: boolean;
    extension: string;
    rawExtension: string;
    rawString?: string | undefined;
}, {
    type: "extensionTag";
    tag: string;
    children: Record<string, any>;
    offset: number;
    isComplete: boolean;
    extension: string;
    rawExtension: string;
    rawString?: string | undefined;
}>;
export declare const AttributeFragmentSchema: z.ZodObject<{
    type: z.ZodLiteral<"attribute">;
    name: z.ZodString;
    value: z.ZodOptional<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"string">;
        value: z.ZodString;
        isComplete: z.ZodLiteral<true>;
    }, "strip", z.ZodTypeAny, {
        type: "string";
        value: string;
        isComplete: true;
    }, {
        type: "string";
        value: string;
        isComplete: true;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"boolean">;
        value: z.ZodBoolean;
        isComplete: z.ZodLiteral<true>;
    }, "strip", z.ZodTypeAny, {
        type: "boolean";
        value: boolean;
        isComplete: true;
    }, {
        type: "boolean";
        value: boolean;
        isComplete: true;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"array">;
        items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[], any[]>;
        isComplete: z.ZodBoolean;
    }, "strip", z.ZodTypeAny, {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }, {
        type: "array";
        isComplete: boolean;
        items: any[];
    }>]>>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "attribute";
    name: string;
    isComplete: boolean;
    value?: {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    } | undefined;
}, {
    type: "attribute";
    name: string;
    isComplete: boolean;
    value?: {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: any[];
    } | undefined;
}>;
export declare const AllFragmentsSchema: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    type: z.ZodLiteral<"array">;
    items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    })[], any[]>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "array";
    isComplete: boolean;
    items: ({
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    })[];
}, {
    type: "array";
    isComplete: boolean;
    items: any[];
}>, z.ZodObject<{
    type: z.ZodLiteral<"attribute">;
    name: z.ZodString;
    value: z.ZodOptional<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"string">;
        value: z.ZodString;
        isComplete: z.ZodLiteral<true>;
    }, "strip", z.ZodTypeAny, {
        type: "string";
        value: string;
        isComplete: true;
    }, {
        type: "string";
        value: string;
        isComplete: true;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"boolean">;
        value: z.ZodBoolean;
        isComplete: z.ZodLiteral<true>;
    }, "strip", z.ZodTypeAny, {
        type: "boolean";
        value: boolean;
        isComplete: true;
    }, {
        type: "boolean";
        value: boolean;
        isComplete: true;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"array">;
        items: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[], any[]>;
        isComplete: z.ZodBoolean;
    }, "strip", z.ZodTypeAny, {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }, {
        type: "array";
        isComplete: boolean;
        items: any[];
    }>]>>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "attribute";
    name: string;
    isComplete: boolean;
    value?: {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    } | undefined;
}, {
    type: "attribute";
    name: string;
    isComplete: boolean;
    value?: {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: any[];
    } | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"boolean">;
    value: z.ZodBoolean;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}, {
    type: "boolean";
    value: boolean;
    isComplete: true;
}>, z.ZodObject<{
    type: z.ZodLiteral<"rule">;
    rule: z.ZodString;
    children: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>, Record<string, any>>;
    isComplete: z.ZodBoolean;
}, "strip", z.ZodTypeAny, {
    type: "rule";
    rule: string;
    children: Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>;
    isComplete: boolean;
}, {
    type: "rule";
    rule: string;
    children: Record<string, any>;
    isComplete: boolean;
}>, z.ZodObject<{
    type: z.ZodLiteral<"preparedExtensionTag">;
    extension: z.ZodString;
    rawExtension: z.ZodString;
    offset: z.ZodNumber;
    isComplete: z.ZodLiteral<false>;
}, "strip", z.ZodTypeAny, {
    type: "preparedExtensionTag";
    offset: number;
    isComplete: false;
    extension: string;
    rawExtension: string;
}, {
    type: "preparedExtensionTag";
    offset: number;
    isComplete: false;
    extension: string;
    rawExtension: string;
}>, z.ZodObject<{
    type: z.ZodLiteral<"extensionTag">;
    extension: z.ZodString;
    rawExtension: z.ZodString;
    tag: z.ZodString;
    children: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>, Record<string, any>>;
    isComplete: z.ZodBoolean;
    offset: z.ZodNumber;
    rawString: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "extensionTag";
    tag: string;
    children: Record<string, {
        type: "string";
        value: string;
        isComplete: true;
    } | {
        type: "boolean";
        value: boolean;
        isComplete: true;
    } | {
        type: "array";
        isComplete: boolean;
        items: ({
            type: "string";
            value: string;
            isComplete: true;
        } | {
            type: "boolean";
            value: boolean;
            isComplete: true;
        })[];
    }>;
    offset: number;
    isComplete: boolean;
    extension: string;
    rawExtension: string;
    rawString?: string | undefined;
}, {
    type: "extensionTag";
    tag: string;
    children: Record<string, any>;
    offset: number;
    isComplete: boolean;
    extension: string;
    rawExtension: string;
    rawString?: string | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"string">;
    value: z.ZodString;
    isComplete: z.ZodLiteral<true>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    value: string;
    isComplete: true;
}, {
    type: "string";
    value: string;
    isComplete: true;
}>]>;
export type AllFragments = z.infer<typeof AllFragmentsSchema>;
export type ArrayFragment = z.infer<typeof ArrayFragmentSchema>;
export type AttributeFragment = z.infer<typeof AttributeFragmentSchema>;
export type BooleanFragment = z.infer<typeof BooleanFragmentSchema>;
export type ChildFragments = Record<string, ValueFragments>;
export type PrimitiveFragments = z.infer<typeof PrimitiveFragmentsSchema>;
export type RuleFragment = z.infer<typeof RuleFragmentSchema>;
export type PreparedExtensionTagFragment = z.infer<typeof PreparedExtensionTagFragmentSchema>;
export type ExtensionTagFragment = z.infer<typeof ExtensionTagFragmentSchema>;
export type StringFragment = z.infer<typeof StringFragmentSchema>;
export type ValueFragments = z.infer<typeof ValueFragmentsSchema>;
export type ResultFragment = RuleFragment | ExtensionTagFragment;
export declare function string(value: string): StringFragment;
export declare function boolean(value: string | boolean): BooleanFragment;
export declare function rule(rule: string, children?: ChildFragments, isComplete?: boolean): RuleFragment;
export declare function preparedExtensionTag(extension: string, rawExtension: string, offset: number): PreparedExtensionTagFragment;
export declare function extensionTag(extension: string, rawExtension: string, tag: string, offset: number, children?: ChildFragments, rawString?: string, isComplete?: boolean): ExtensionTagFragment;
export declare function attribute(name: string, value?: ValueFragments, isComplete?: boolean): AttributeFragment;
export declare function array(items?: PrimitiveFragments[], isComplete?: boolean): ArrayFragment;
export declare function isValue(data: unknown): data is ValueFragments;
export declare function isPrimitive(data: unknown): data is PrimitiveFragments;
export {};
