"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extensionTags = void 0;
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const common_1 = require("./common");
const maven_1 = require("./maven");
const oci_1 = require("./oci");
// In bazel modules an extension tag is (roughly) a "member function application".
// For example:
//
//     oci = use_extension("@rules_oci//oci:extensions.bzl", "oci")
//     ^^^ --> the extension definition (not parsed by this module)
//
//     oci.pull(<parameters>)
//         ^^^^ --> the extension tag
//
// The name of the extension (`oci` in the example above) technically arbitrary.
// However, in practice, there are conventions. We use this to simplify parsing
// by assuming the extension names start with well-known prefixes.
const supportedExtensionRegex = (0, regex_1.regEx)(`^(${oci_1.ociExtensionPrefix}|${maven_1.mavenExtensionPrefix}).*$`);
const supportedExtensionTags = [...maven_1.mavenExtensionTags, ...oci_1.ociExtensionTags];
const supportedExtensionTagsRegex = (0, regex_1.regEx)(`^(${supportedExtensionTags.join('|')})$`);
exports.extensionTags = good_enough_parser_1.query
    .sym(supportedExtensionRegex, (ctx, token) => {
    const rawExtension = token.value;
    const match = rawExtension.match(supportedExtensionRegex);
    const extension = match[1];
    return ctx.prepareExtensionTag(extension, rawExtension, token.offset);
})
    .op('.')
    .sym(supportedExtensionTagsRegex, (ctx, token) => {
    return ctx.startExtensionTag(token.value);
})
    .join(good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    search: common_1.kvParams,
    postHandler: (ctx, tree) => {
        if (tree.type === 'wrapped-tree') {
            const { endsWith } = tree;
            const endOffset = endsWith.offset + endsWith.value.length;
            return ctx.endExtensionTag(endOffset);
        }
        // istanbul ignore next
        throw new Error(`Unexpected tree in postHandler: ${tree.type}`);
    },
}));
//# sourceMappingURL=extension-tags.js.map