"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.kvParams = void 0;
const tslib_1 = require("tslib");
const good_enough_parser_1 = require("good-enough-parser");
const regex_1 = require("../../../../util/regex");
const starlark = tslib_1.__importStar(require("./starlark"));
const booleanValuesRegex = (0, regex_1.regEx)(`^${starlark.booleanStringValues.join('|')}$`);
/**
 * Matches key-value pairs:
 * - `name = "foobar"`
 * - `name = True`
 * - `name = ["string"]`
 **/
exports.kvParams = good_enough_parser_1.query
    .sym((ctx, token) => ctx.startAttribute(token.value))
    .op('=')
    .alt(good_enough_parser_1.query.str((ctx, token) => ctx.addString(token.value)), good_enough_parser_1.query.sym(booleanValuesRegex, (ctx, token) => ctx.addBoolean(token.value)), good_enough_parser_1.query.tree({
    type: 'wrapped-tree',
    maxDepth: 1,
    startsWith: '[',
    endsWith: ']',
    postHandler: (ctx) => ctx.endArray(),
    preHandler: (ctx) => ctx.startArray(),
    search: good_enough_parser_1.query.many(good_enough_parser_1.query.str((ctx, token) => ctx.addString(token.value))),
}));
//# sourceMappingURL=common.js.map